<%@ Page Title="" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PolyTraumaEntries.aspx.cs" Inherits="PolyTraumaTracking" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <script type="text/javascript">
        $(document).ready(function () {
            $("a:contains('Reporting')").attr('href', 'PolyTraumaEntry.aspx');
        });
    </script>



    <p>
        <br />
        <div class = "excludeSaveWarnings">
        <asp:Label ID="LabelForDropDownListPolyTraumaVAMC" runat="server" AssociatedControlID="DropDownListPolyTraumaVAMC">
        Filter on Polytrauma VAMC: 
        </asp:Label>
        <asp:DropDownList ID="DropDownListPolyTraumaVAMC" runat="server" AutoPostBack="true"
            DataSourceID="ObjectDataSourcePolyTraumaVAMC" DataTextField="Name" 
            DataValueField="institution_id"
            OnSelectedIndexChanged="DropDownListPolyTraumaVAMC_OnSelectedIndexChanged"
            AppendDataBoundItems="true">
            <asp:ListItem Value="0">-- Show All --</asp:ListItem>
        </asp:DropDownList>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:Label ID="LabelForDropDownListPolyTraumaEntryType" runat="server" AssociatedControlID="DropDownListPolyTraumaVAMC">
        Filter on Polytrauma Entry Type: 
        </asp:Label>
        <asp:DropDownList ID="ddlPolyTraumaEntryType" runat="server" AutoPostBack="true"
            DataSourceID="ObjectDataSourcePolyTraumaEntryType" 
            DataTextField="Code" 
            DataValueField="ID" 
            OnSelectedIndexChanged="ddlPolyTraumaEntryType_OnSelectedIndexChanged"
            AppendDataBoundItems="true">
            <asp:ListItem Value="0">-- Show All --</asp:ListItem>
        </asp:DropDownList>
        
        <br />
        <br />
        </div> 
        <asp:ObjectDataSource ID="ObjectDataSourcePolyTraumaVAMC" runat="server" 
            SelectMethod="GetPolyTraumaVAMCList" 
            TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
        </asp:ObjectDataSource>
        
        <asp:ObjectDataSource ID="ObjectDataSourcePolyTraumaEntryType" runat="server" 
            SelectMethod="GetPolytraumaEntryType" 
            TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
        </asp:ObjectDataSource>
        
        <asp:GridView ID="GridViewPolyTraumaEntries" runat="server" Width="100%" OnRowCommand = "GridViewPolyTraumaEntries_RowCommand" 
            AutoGenerateColumns="False" 
            Summary="This table is a list of polytrauma entries filtered by the value in the Filter on Polytrauma VAMC dropdown control.  Column headers are clickable to sort and reverse sort the table by that column."
            DataSourceID="ObjectDataSourcePolyTraumaEntries"
            AllowPaging="True" AllowSorting="True"
            DataKeyNames="TBI_POLYTRAUMA_ID">
            <Columns>
                <asp:BoundField  DataField="TBI_POLYTRAUMA_ID"
                    HeaderText="ID" SortExpression="TBI_POLYTRAUMA_ID"  >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" Width="20px" />
                </asp:BoundField>

                <asp:TemplateField HeaderText="SSN" SortExpression="Snum" 
                    AccessibleHeaderText="SSN">
                    <ItemTemplate>
                        <asp:Label ID="LabelSSN" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Snum")))%>'></asp:Label>        
                    
                    </ItemTemplate>         
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Center" Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Patient Name" SortExpression="LAST_NAME">
                   <ItemTemplate>
                        <asp:Label ID="LabelPatientLastName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("LAST_NAME"))) %>'></asp:Label>,&nbsp;
                        <asp:Label ID="LabelPatientFirstName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("FIRST_NAME"))) %>'></asp:Label>
                        <asp:Label ID="LabelPatientMiddleName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("MIDDLE_NAME"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Left" />
                    <ItemStyle HorizontalAlign="Left" Width="200px" />
                </asp:TemplateField>
                    
                <asp:TemplateField HeaderText="MTF / Referral Source" SortExpression="STD_TBIFACILITYSRC.NAME">
                    <ItemTemplate>
                        <asp:Label ID="LabelReferallSource" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_TBIFACILITYSRC.NAME")))%>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Left" />
                    <ItemStyle HorizontalAlign="Left" Width="120px" />
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Polytrauma VAMC" SortExpression="STD_INSTITUTION1.VISN_ID">
                    <ItemTemplate>
                        (<asp:Label ID="LabelVamcVisn" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.STD_INSTITUTION_PARENT.NAME")))%>'></asp:Label>)
                        (<asp:Label ID="LabelVamcStationNumber" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.STATIONNUMBER")))%>'></asp:Label>)
                        <asp:Label ID="LabelVamcVistaName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION1.VISTANAME")))%>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Left" />
                    <ItemStyle HorizontalAlign="Left"  />
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Injury Date" SortExpression="TBI_INJURY_DATE">
                    <ItemTemplate>
                        <asp:Label ID="LabelInjuryDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TBI_INJURY_DATE","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Center" Width="70px" />
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Last Updated" SortExpression="UPDATED">
                    <ItemTemplate>
                        <asp:Label ID="LabelReferralDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("UPDATED","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemStyle HorizontalAlign="Center" Width="70px" />
                </asp:TemplateField>
            
                <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details"
                       ItemStyle-VerticalAlign="Middle" 
                       ItemStyle-HorizontalAlign="Center" 
                       AccessibleHeaderText = "Select"
                       ItemStyle-Width="50px"  />
            </Columns>
        </asp:GridView>
        <br />
        <asp:Button ID="ButtonDownloadToExcel" runat="server" onclick="ButtonDownloadToExcel_Click" 
            Text="Download To Excel" />
        <br />
        <asp:ObjectDataSource ID="ObjectDataSourcePolyTraumaEntries" runat="server" 
            SelectMethod="SelectByPolyTraumaVAMC" 
            SelectCountMethod="SelectByPolyTraumaVAMCCount" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManager.TBI.PolyTraumaEntriesManager">
            <SelectParameters>
                <asp:ControlParameter ControlID="DropDownListPolyTraumaVAMC" DefaultValue="0" 
                    Name="polyTraumaVamcID" PropertyName="SelectedValue" Type="Int32" />
                <asp:ControlParameter ControlID="ddlPolyTraumaEntryType" DefaultValue="0" 
                    Name="entryTypeID" PropertyName="SelectedValue" Type="Int32" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        
        <asp:GridView ID="GridViewDownloadToExcel" runat="server" Width="100%"
            AutoGenerateColumns="true" Visible="false"
            Summary="This table is a list of polytrauma entries filtered by the value in the Filter on Polytrauma VAMC dropdown control.  Column headers are clickable to sort and reverse sort the table by that column."
            DataSourceID="ObjectDataSourceDownLoadViewByPolyTraumaVAMC"
            AllowPaging="True" AllowSorting="True"></asp:GridView>
       <asp:ObjectDataSource ID="ObjectDataSourceDownLoadViewByPolyTraumaVAMC" runat="server" 
            SelectMethod="SelectDownLoadViewByPolyTraumaVAMC" 
            SelectCountMethod="SelectDownLoadViewByPolyTraumaVAMCCount" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManager.TBI.PolyTraumaEntriesManager">
            <SelectParameters>
                <asp:ControlParameter ControlID="DropDownListPolyTraumaVAMC" DefaultValue="0" 
                    Name="polyTraumaVamcID" PropertyName="SelectedValue" Type="Int32" />
                <asp:ControlParameter ControlID="ddlPolyTraumaEntryType" DefaultValue="0" 
                    Name="entryTypeID" PropertyName="SelectedValue" Type="Int32" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
                
    </p>
</asp:Content>

